<?php

namespace DownGrade\Http\Controllers\Admin;


use Illuminate\Http\Request;
use DownGrade\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\File;
use DownGrade\Models\Settings;
use DownGrade\Models\EmailTemplate;
use DownGrade\Models\Members;
use DownGrade\Models\Addons;
use Auth;
use Mail;
use Artisan;
use Helper;
use ZipArchive;
use Nwidart\Modules\Facades\Module;

class AddonsController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
		
    }
    
	public function custom()
	{
	    $dw_v = Helper::version_no();
		$custom = Settings::editCustom();
		return $custom->$dw_v;
	} 
	
	public function logout(Request $request) {
	  $data = array("google2fa_access" => "no");
	  Members::verifyuserData(Auth::user()->user_token,$data);
	  Auth::logout();
	  return redirect('/login');
    }
	
	
	public function delete_cache()
	{
	    Artisan::call('cache:clear');
		Artisan::call('view:clear');
		Artisan::call('config:cache');
		Artisan::call('optimize:clear');
		/*return redirect(admin/contact)->with('success','All cache data has been cleared');*/
		return redirect()->back()->with('success','All cache data has been cleared');
		
	}
	
	
	public function deactivate_addon($addon_id)
	{
	   $encrypter = app('Illuminate\Contracts\Encryption\Encrypter');
	   $id   = $encrypter->decrypt($addon_id);
	   $singleaddon = Addons::singleAddon($id);
	   Artisan::call('module:disable', ['module' => $singleaddon->addon_slug, '--no-interaction' => true]);
	   $data = array('addon_status' => 0);
	   Addons::updateAddon($id,$data);
	   /* clear cache */
	   Artisan::call('optimize:clear');
	   /* clear cache */
	   return redirect()->back()->with('success','Deactivated successfully');
	    
	}
	
	public function activate_addon($addon_id)
	{
	   $encrypter = app('Illuminate\Contracts\Encryption\Encrypter');
	   $id   = $encrypter->decrypt($addon_id);
	   $singleaddon = Addons::singleAddon($id);
	   Artisan::call('module:enable', ['module' => $singleaddon->addon_slug, '--no-interaction' => true]);
	   $data = array('addon_status' => 1);
	   Addons::updateAddon($id,$data);
	   /* clear cache */
	   Artisan::call('optimize:clear');
	   /* clear cache */
	   return redirect()->back()->with('success','Activated successfully');
	    
	}
	
	public function delete_addon($addon_id)
	{
	   $encrypter = app('Illuminate\Contracts\Encryption\Encrypter');
	   $id   = $encrypter->decrypt($addon_id);
	   $singleaddon = Addons::singleAddon($id);
	   Artisan::call('module:disable', ['module' => $singleaddon->addon_slug, '--no-interaction' => true]);
	   File::deleteDirectory(base_path('/Modules/'.$singleaddon->addon_slug));
	   Addons::deleteAddon($id);
	   /* clear cache */
	   Artisan::call('optimize:clear');
	   /* clear cache */
	   return redirect()->back()->with('success','Deleted successfully');
	    
	}
	
	public function upload_addon(Request $request) 
	{
	  
	   $this->validate($request, [
		 
		                    'addon_purchased_code' => 'required',
							'upload_addon_file' => 'mimes:zip',

        	]);
        
		$rules = array();
		$messages = array();
		$validator = Validator::make($request->all(), $rules, $messages);
		if ($validator->fails())
		{
			$failedRules = $validator->failed();
			return back()->withErrors($validator);
		}
		else
		{ 
			
			$purchased_code = $request->input('addon_purchased_code');
			$code= $purchased_code; 
			$url = "https://api.envato.com/v3/market/author/sale?code=".$code;
			$curl = curl_init($url);
			$personal_token = "sS3y8m5fMdYZMWVbSPtI7LdJYmtC9F2O";
			$header = array();
			$header[] = 'Authorization: Bearer '.$personal_token;
			$header[] = 'User-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:41.0) Gecko/20100101 Firefox/41.0';
			$header[] = 'timeout: 20';
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($curl, CURLOPT_HTTPHEADER,$header);
			$envatoRes = curl_exec($curl);
			curl_close($curl);
			$envatoRes = json_decode($envatoRes);
			
			//if($envatoRes->license == base64_decode(Helper::key_no())){ $key_val = 1; } else { $key_val = 0; }
			
			
			
			if (isset($envatoRes->item->name)) 
			{   
			$addon_thumb = $envatoRes->item->previews->icon_with_landscape_preview->icon_url;
			$addon_name = $envatoRes->item->name;
			$addon_id = $envatoRes->item->id;
			   
					    if ($request->hasFile('upload_addon_file')) 
					    {
							$image = $request->file('upload_addon_file');
							$originalFileName = $image->getClientOriginalName();
							$fileNameWithoutExtension = pathinfo($originalFileName, PATHINFO_FILENAME);
							
							$img_name = time() . uniqid().'.'.$image->getClientOriginalExtension();
							
							$destinationPath = base_path('/public/storage/data/');
							$imagePath = $destinationPath. "/".  $img_name;
							$image->move($destinationPath, $img_name);
							$addition_data = array('upgrade_files' => $img_name);
							Settings::updateCustomData($addition_data);
							
							$countaddon = Addons::checkAddon($addon_id);
							
							$zip = new ZipArchive;
							$zip->open(base_path('/public/storage/data/'.$img_name));
							$zip->extractTo(base_path('/Modules/'));
							Settings::deleteUpgrade();
							
							Artisan::call('module:enable', ['module' => $fileNameWithoutExtension, '--no-interaction' => true]);
							/* clear cache */
							Artisan::call('cache:clear');
							Artisan::call('optimize:clear');
							/* clear cache */
							if($countaddon == 0)
							{
							$data = array('addon_name' => $addon_name, 'addon_slug' => $fileNameWithoutExtension, 'addon_image' => $addon_thumb,  'addon_status' => 1, 'addon_envato_id' => $addon_id);
							Addons::saveAddon($data);
							}
						
						
						}
						
						
						return redirect()->back()->with('success','Success! Installation Done');
						
			} 
			else 
			{  
						return redirect()->back()->with('error','FAILED: Invalid Addon Purchase Code');
						
			} 
			
			
			
		}	
	
	}
	
	
	
	public function view_install_addon()
	{
	   if($this->custom() != 0)
	   {
		   
	     if(!empty(Auth::user()->google2fa_secret) && (Auth::user()->google2fa_access == "yes"))
			{
			return view('admin.install-addon');
			}
			else if(empty(Auth::user()->google2fa_secret))
			{
			return view('admin.install-addon');
			}
			else
			{
			return redirect('/2fa');  
			}
		 
	   }
	   else
	   {
		  return redirect('/admin/license');
	   }
	}
	
	
	public function view_addons()
	{
	  
	  $getaddons = Addons::getaddonsViews();
	  $data = array('getaddons' => $getaddons);
	  if($this->custom() != 0)
	  {
	  
	    
		if(!empty(Auth::user()->google2fa_secret) && (Auth::user()->google2fa_access == "yes"))
			{
			return view('admin.addons')->with($data);
			}
			else if(empty(Auth::user()->google2fa_secret))
			{
			return view('admin.addons')->with($data);
			}
			else
			{
			return redirect('/2fa');  
			}
	  
	  }
	  else
	  {
		  return redirect('/admin/license');
	  }
	
	}
	
	
	
	
}
