<!doctype html>
<!--[if lt IE 7]>      <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang=""> <![endif]-->
<!--[if IE 7]>         <html class="no-js lt-ie9 lt-ie8" lang=""> <![endif]-->
<!--[if IE 8]>         <html class="no-js lt-ie9" lang=""> <![endif]-->
<!--[if gt IE 8]><!-->
<html class="no-js" lang="en">
<!--<![endif]-->

<head>
    
    @include('admin.stylesheet')
</head>

<body>
    
    @include('admin.navigation')

    <!-- Right Panel -->
    @if(in_array('etemplate',$avilable))
    <div id="right-panel" class="right-panel">

        
                       @include('admin.header')
                       

        <div class="breadcrumbs">
            <div class="col-sm-4">
                <div class="page-header float-left">
                    <div class="page-title">
                        <h1>{{ __('Email Template') }}</h1>
                    </div>
                </div>
            </div>
            <div class="col-sm-8">
                <div class="page-header float-right">
                    <div class="page-title">
                        
                    </div>
                </div>
            </div>
        </div>
        
         @include('admin.warning')
        <div class="content mt-3">
            <div class="animated fadeIn">
            
            <div class="row">

                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-header">
                                <strong class="card-title">{{ __('Email Template') }}</strong>
                            </div>
                            <div class="card-body">
                                <table id="example" class="table table-striped table-bordered">
                                    <thead>
                                        <tr>
                                            <th width="10%">{{ __('Sno') }}</th>
                                            <th width="40%">{{ __('Name') }}</th>
                                            <th width="30%">{{ __('Subject') }}</th>
                                            <th>{{ __('Action') }}</th>
                                            
                                            
                                        </tr>
                                    </thead>
                                    <tbody>
                                    @php $no = 1; @endphp
                                    @foreach($templateData['view'] as $template)
                                        <tr>
                                            <td>{{ $no }}</td>
                                            <td width="200">{{ $template->et_heading }} </td>
                                            <td width="200">{{ $template->et_subject }} </td>
                                            <td><a href="{{ url('/admin') }}/edit-email-template/{{ $template->et_id }}" class="btn btn-success btn-sm"><i class="fa fa-edit"></i>&nbsp; {{ __('Edit') }}</a> 
                                            </td>
                                        </tr>
                                        
                                        @php $no++; @endphp
                                   @endforeach     
                                        
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

 
                </div>
            </div><!-- .animated -->
        </div><!-- .content -->


    </div><!-- /#right-panel -->
    @else
    @include('admin.denied')
    @endif
    <!-- Right Panel -->


   @include('admin.javascript')

<script type="text/javascript">
      $(document).ready(function () { 
    var oTable = $('#example').dataTable({
        stateSave: true,
		responsive: true,
		dom: 'Bfrtip',
        buttons: [
                {
                    extend: 'copy',
                    exportOptions: {
                        columns: [0, 1, 2]
                    },
					className: 'ml-4 mr-1',
					filename: '{{ $allsettings->site_title }} - Email-template'
                },
                {
                    extend: 'csv',
                    exportOptions: {
                        columns: [0, 1, 2]
                    },
					className: 'mr-1',
					filename: '{{ $allsettings->site_title }} - Email-template'
                },
                {
                    extend: 'excel',
                    exportOptions: {
                        columns: [0, 1, 2]
                    },
					className: 'mr-1',
					filename: '{{ $allsettings->site_title }} - Email-template'
                },
				{
                    extend: 'pdf',
                    exportOptions: {
                        columns: [0, 1, 2]
                    },
					className: 'mr-1',
					filename: '{{ $allsettings->site_title }} - Email-template'
                },
				{
                    extend: 'print',
                    exportOptions: {
                        columns: [0, 1, 2]
                    },
					className: 'mr-1',
					filename: '{{ $allsettings->site_title }} - Email-template'
                }
                
            ]
    });

    
      


	
	
	});

</script>
</body>

</html>
